//
//  MCFieldOptionRegistry.h
//  MCFoundation
//
//  Created by Ali Lalani on 3/14/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MCPObjectContext;
@interface MCFieldOptionRegistry : NSObject {
	NSMutableDictionary *_entities;
	MCPObjectContext    *_objectContext;
}
// This just registers it in-memory, use this if you grabbed it from the database, it will not be re-added
- (void)registerOptionWithEntityName:(NSString *)entityName
							 keyName:(NSString *)keyName
						 optionValue:(NSString *)optionValue;

// This registers and sends out the notification didAdd so that database level frameworks can save it to the database
- (void)addOptionWithEntityName:(NSString *)entityName
						keyName:(NSString *)keyName
					optionValue:(NSString *)optionValue;

- (NSArray *)optionsForEntityName:(NSString *)entityName keyName:(NSString *)keyName;

- (void)setEntities:(NSDictionary *)entities;
- (NSMutableDictionary *)entities;

- (MCPObjectContext *)objectContext;
- (void)setObjectContext:(MCPObjectContext *)anObjectContext;
@end
